 ; Ŀ
 ;   Kx - remove xdata from a drawing.                                     
 ;   Copyright 2002 by Rocket Software Ltd.                                
 ;   There are no special Jello cutting knives.                            
 ; 

 ; Ŀ
 ;   Subroutine CI - grdraw circle maker.                                  
 ; 
 (DEFUN CI (pa radd colo / reps pa pa1 pa2 angg)
  (setq reps 32)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg radd))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Ci end.                                                               
 ; 

 ; Ŀ
 ;   Cici - another grdraw pattern maker.                                  
 ;   Argument: Pa, the base point.                                         
 ;   Calls Ci and Radi, returns nothing.                                   
 ; 
 (DEFUN CICI (pa / rad)
  (setq rad (/ (getvar "viewsize") 25))
 ; Ŀ
 ;   Draw two circles.                                                     
 ; 
  (ci pa (* rad 0.5) 4)
  (ci pa (* rad 0.35) 4)
 ; Ŀ
 ;   Crosslines.                                                           
 ; 
  (radi pa (* rad 0.2) rad 4 0 1)
 ; Ŀ
 ;   Radial lines.                                                         
 ; 
  (radi pa (* rad 0.25) (* rad 0.8) 4 (* pi 0.25) 1)
 ; Ŀ
 ;   Lines between rings.                                                  
 ; 
  (radi pa (* rad 0.35) (* rad 0.5) 25 0 2)
 (princ))
 ; Ŀ
 ;   Cici end.                                                             
 ; 

 ; Ŀ
 ;   Exkill - remove the extended data from an entity.                     
 ;   Amazingly, this works: remove everything from the xdata for the       
 ;   app in question except the app name, entmod it back in, acad          
 ;   ditches the entire app xdata set from that entity.                    
 ;   Completely removing the xdata for that app doesn't work - acad        
 ;   assumes that it isn't touching the xdata for that app at all.         
 ;                                                                         
 ;   Arguments: Enam - the entity name.                                    
 ;              appi - the application to remove the data for.             
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN EXKILL (enam appi / entt exdat sub nuex)
  (setq entt (entget enam (list "*")))
  (if (setq exdat (assoc -3 entt))
      (progn
           (while (setq sub (car exdat))
                  (setq exdat (cdr exdat))
                  (if (and (= (type sub) 'LIST)
                           (= (car sub) appi))
                      (setq nuex (append nuex (list (list (car sub)))))
                      (setq nuex (append nuex (list sub)))))
           (entmod (append (entget enam) (list nuex)))))
 (princ))
 ; Ŀ
 ;   Exkill end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Fibox - display a list of strings in a dialog box.         
 ;   Arguments: Styldt, the application names list.                        
 ;              Lenlst, the list of app data selection set lengths.        
 ;              Rad, the marker X length.                                  
 ;   Returns nothing.                                                      
 ; 
 (DEFUN FIBOX (styldt lenlst rad / fpath dcl_id num numf filnam fnam malist
                                                                     findx ret)
  (setq dcl_id (load_dialog "kx.dcl"))
  (new_dialog "kx" dcl_id)      ; must come before data for list box
 ; Ŀ
 ;   Make the Style list for the list box.                                 
 ; 
  (start_list "the_list")        ; read style data list into list box
  (setq num 0)
  (while (setq stylnm (nth num styldt))
         (add_list stylnm)
         (setq malist (cons stylnm malist))
         (setq num (1+ num)))
  (end_list)
  (setq malist (reverse malist))
  (set_tile "babtext" (strcat (itoa num) " applications."))
 ; Ŀ
 ;   Actions for given buttons/selections.  Must come after New_dialog     
 ;   call and before Start_dialog.                                         
 ; 
  (action_tile "select_ok" "(setq lenlst (selok malist lenlst rad))")
  (action_tile "the_list" "(setq lenlst (lisok $reason malist lenlst rad))")
  (action_tile "fcancel" "(setq findx ())")
 ; Ŀ
 ;   Run it.                                                               
 ; 
  (setq ret (start_dialog))
  (unload_dialog dcl_id))
 ; Ŀ
 ;   Fibox end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Lisok - if the list box generated a callback, see if it    
 ;   was a double click or an Enter, in which case call Selok to deal      
 ;   with the xdata for the selected app.                                  
 ;   Returns a (possibly updated) lenlst.                                  
 ; 
 (DEFUN LISOK (reason malist lenlst rad / lisval num)
  (setq lisval (get_tile "the_list"))
  (if (= reason 4)
      (setq lenlst (selok malist lenlst rad))
      (set_tile "babtext" (strcat (itoa (setq num (nth (read lisval) lenlst)))
                                  " Entit"
                                  (if (= num 1) "y" "ies")
                                  ".")))
 lenlst)
 ; Ŀ
 ;   Lisok end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Radi - grdraw radial line set maker.                       
 ;   Does a complete circular set.                                         
 ;   Arguments: Pa, the base point.                                        
 ;              Rin, near end distance.                                    
 ;              Rout, far end distance.                                    
 ;              Reps, number of repetions in 360 degrees.                  
 ;              Stang, the start angle.                                    
 ;              Colo, the colour.                                          
 ;   Calls its mother, returns the empties.                                
 ;                                                                         
 ; 
 (DEFUN RADI (pa rin rout reps stang colo / pa1 pa2)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (setq pa1 (polar pa stang rin))
          (setq pa2 (polar pa stang rout))
          (grdraw pa1 pa2 colo)
          (setq stang (+ stang incr)))
 (princ))
 ; Ŀ
 ;   Radi end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Selok - if Kill was pressed, see if an app name was        
 ;   selected, if so exit the dialog box and return the zero based index   
 ;   of that name.  Otherwise show an error.                               
 ;   Arguments: Malist, the list of application names.                     
 ;              Lenlst, the list of numbers of entities with xdata.        
 ;              Rad, the marker X length.                                  
 ;   Calls Xdk.                                                            
 ;   Returns the updated lenlst.                                           
 ; 
 (DEFUN SELOK (malist lenlst rad / lisval pos appnam num sub gnulst)
  (setq lisval (get_tile "the_list"))
 ; Ŀ
 ;   If a name was selected and Kill was pressed, find the app name from   
 ;   the name list and call Xdk to erase all matching xdata.               
 ;   Otherwise show an error.                                              
 ; 
  (if (and lisval (/= lisval ""))
      (progn
           (if (= (nth (setq pos (read lisval)) lenlst) 0)
               (set_tile "babtext" "No entities for this app.")
               (progn
                    (setq appnam (nth (read lisval) malist))
                    (xdk appnam rad)
 ; Ŀ
 ;   Have deleted xdata for an app, so replace its number of entities in   
 ;   the length list with 0.                                               
 ; 
                    (setq num 0)
                    (while (setq sub (nth num lenlst))
                           (if (= num pos) (setq sub 0))
                           (setq num (1+ num))
                           (setq gnulst (append gnulst (list sub))))
                    (set_tile "babtext" "Xdata deleted."))))
      (set_tile "babtext" "You must select an Application."))
 (if gnulst gnulst lenlst))
 ; Ŀ
 ;   Selok end.                                                            
 ; 

 ; Ŀ
 ;   Xdk - remove all xdata for a given application.                       
 ;   Arguments: Daapp, the application name.                               
 ;              Rad, the marker size.                                      
 ;   Calls Cici and Exkill.                                                
 ;   Returns the number of entities de-exdataed.                           
 ; 
 (DEFUN XDK (daapp rad / ss num enam pa)
 ; Ŀ
 ;   Get an ss of all entities with xdata for the named app.               
 ; 
  (setq ss (ssget "X" (list (list -3 (list daapp)))))
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq pa (cdr (assoc 10 (entget enam))))
         (cici pa)
 ; Ŀ
 ;   Application names are listed at the end of the standard entget call,  
 ;   wild cards (such as *) or specific program names are allowed.         
 ; 
         (exkill enam daapp))
 num)
 ; Ŀ
 ;   Subroutine Xdk end.                                                   
 ; 

 ; Ŀ
 ;   Kx.                                                                   
 ; 
 (DEFUN C:KX (/ rad rew nxtap ss lenlst apple)
  (setq rad (/ (getvar "viewsize") 20))
  (setq rew t)
 ; Ŀ
 ;   Get a list of xdata applications.                                     
 ; 
  (while (setq nxtap (tblnext "appid" rew))
         (setq nxtap (cdadr nxtap))
         (setq apple (cons nxtap apple))
         (setq rew ()))
  (setq apple (acad_strlsort apple))
 ; Ŀ
 ;   Get a total number of entities with xdata for each application.       
 ; 
  (setq num 0)
  (while (setq nxtap (nth num apple))
         (setq num (1+ num))
         (if (setq ss (ssget "X" (list (list -3 (list nxtap)))))
             (setq len (sslength ss))
             (setq len 0))
         (setq lenlst (cons len lenlst)))
  (setq lenlst (reverse lenlst))
 ; Ŀ
 ;   Call the dialog box to orchestrate the massacre.                      
 ; 
  (fibox apple lenlst rad)
 (princ))